<?php
/**
 * Sends an email by making a POST request to the specified API endpoint.
 *
 * @param string $to Recipient's email address.
 * @param string $subject Subject of the email.
 * @param string $body HTML body of the email.
 * @return bool|string Returns true if successful, or an error message if failed.
 */

 
function mail2api($to, $subject, $body)
{
    // Validate the input
    if (!filter_var($to, FILTER_VALIDATE_EMAIL)) {
        return "Invalid email address.";
    }

    if (empty($subject)) {
        return "Email subject is required.";
    }

    if (empty($body)) {
        return "Email body is required.";
    }

    $apiUrl = 'https://1tv.ng/singflex.api/mail';

    // Prepare the data
    $data = array(
        'to' => $to,
        'subject' => $subject,
        'body' => $body
    );

    // Initialize cURL
    $ch = curl_init($apiUrl);

    // Configure cURL options
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    // Set HTTP headers
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Accept: application/json'
    ));

    // Execute the POST request
    $response = curl_exec($ch);

    // Check for cURL errors
    if ($response === false) {
        $error = curl_error($ch);
        curl_close($ch);
        return "cURL Error: " . $error;
    }

    // Get HTTP response status code
    $httpStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    curl_close($ch);

    // Parse the response
    $responseData = json_decode($response, true);

    // Handle the response based on status code
    if ($httpStatus >= 200 && $httpStatus < 300) {
        // Success
        return json_decode([ 'status'=> true, 'message'=> "Mail sent successfuly "]);

        //return true;
    } else {
        // Error
        if (isset($responseData['error'])) {
            return json_decode([ 'status'=> false, 'message'=> "API Error: " . $responseData['error']]);
        } else {
   ;

            return json_decode([ 'status'=> false, 'message'=>  "API Error: Received HTTP status code " . $httpStatus]);

        }
    }
}
