// Page Engine 3.0 by Reginald Hassan (c) 1Community Network 2024
let CurrentPage = "home";



class PageEngine {
    constructor(config = {}) {

    

        this.config = {
          default_file_location:'./pages/',
            template: null,
            ...config
        };
        this.trace = (this.config.trace)? this.config.trace:false;
        this.pages = [];
        this.protectedRoute = this.config.protectedRoute||[];
        this.key=this.config.key||'';
        this.user = null;  //session user 
        this.isMember=null;
        this.isArtist = null;
        this.isAdmin = null;
        this.isSuperAdmin= null;
        this.pageLoad = [];
        this.isLogin= false;
        this.member = null;
        this.BUFFER=[];
        this.fat=0;
        this.$QS = (this.config.$QS)? this.config.$QS:"|";
        this.pat= 1000;
        this.ifPass=0;
        this.lastPage=null;
        this.redirect=null;
        this.currentPage = CurrentPage;
        this.default_file_location='./pages/';
        this.onLogin= (this.config.onLogin)? this.config.onLogin:()=>{console.log('---------------- please define your onLogin function');};
        this.PageAction=(this.config.PageAction)? this.config.PageAction:(pageId)=>{ console.log("-----------no Page Action code for", pageId)};
        this.FirstAction=(this.config.FirstAction)? this.config.FirstAction:(pageId)=>{ console.log("------------no First Action code for", pageId)};
        this.navUpdate=(this.config.navUpdate)? this.config.navUpdate:(navcode)=>{ console.log("--------------no navUpdate code ")};
        
        this.hashPage='home';
        this.init();
    }

    async  init() {  
      
      this.User = await this.getSession(); 
      
      this.setPages(this.config.pageIndex); 
   
      this.loadTemplate();
     
      
      //this.User = await this.getSession();
      // this.user =  this.User;
      //this.isLogin =(this.user)? true: false;
  //    console.log("user is ", this.user);
     // this.getSession(this.key);//.then(()=>{
      setTimeout(() => {
        //console.log(engine.Page2go);
       //this.onLogin();
     // this.loadInitialPage();  
      // this.getSession(); 
     }, 200);
      
     setTimeout(() => {
      //console.log(engine.Page2go);
     // this.onLogin();
     //this.loadInitialPage();  
     //if(this.member)this.onLogin(this.member);
    // if(this.member)this.User =this.member;
   }, 500);
    
 
   
    // engine.onLogin();
   //this.loadInitialPage();  
  
   //this.onLogin(this.user, this.isLogin);
    
  //})
   //   console.log( this.protectedRoute);
      //this.hashPage='home';

//this.setupEventListeners();
  }

 getUser() {
        return new Promise((resolve) => {

         
            

   resolve ( this.User);
 
        });
      }
      
      getPageId() {
        return new Promise((resolve) => {

         
            

   resolve ( this.pageId);
 
        });
      }
      
 

 async xxalidatePageAccess(pageId) {
        // Resolve the user first
        const User = await this.getUser();
      

      
        // Use the resolvedUser instead of redefining User
        const GatePass = gatePass||this.config?.gatePass;
        
        if (!gatePass) {
          console.error('gatePass configuration is missing.');
          return null;
        }
      
        console.log(gatePass);
      
        const trace = true;
      
        if (pageId) {
          this.pageId = pageId;
        }
      
        if (trace) console.log("Loading...;", pageId);
      
        try {
          if (trace) console.log("Waiting for the promise to resolve and get the user data;", pageId);
      
          const role =User?.role || 'guest';
      
          console.log({ User });
          if (trace) console.log("Resolved user data:", {User });
      
          if (!Array.isArray(gatePass)) {
            throw new Error("Invalid gatePass configuration");
          }
      
          let passNow =true;
          let rediect ="";
          for (const gate of gatePass) {
            // Check if the pageId starts with gate.path
            if (trace) console.log("Checking: " + gate.path + " & " + pageId);
      
            if (pageId.startsWith(gate.path)) {
              passNow=false;
              redirect = gate.redirect;
              if (trace) console.log("Match found for path:", gate.path);
      
              // Check if the user's role matches the gate's role
              let CheckRole =gate.role;
              const isAGO = await this.isGroup(CheckRole);
              
             // alert(isAGO);


             Promise.all([isAGO ])
  .then((values) => {
  const   isAGO  =values[0];
 

              if (trace) console.log(isAGO," ,<- is a go!! Checking if roles match:", gate.role + " & " + role);
      



              if (isAGO) {


                return pageId;


              } else{


              
              //  return gate.redirect;
  
              }
              
       })
              // If roles don't match, return the gate's redirect path
             // return gate.redirect;
            }

 return (passNow)? pageId : redirect;
            
          }
      
          // If no match is found, return the pageId (or handle 404)
         
        } catch (error) {
          console.error('Error fetching user data:', error);
          return gatePass.redirect ;//|| 'error'; // Return a redirect path or an error identifier
        }
      }
      

      async validatePageAccess(pageId) {
        // Resolve the user first
        const User = await this.getUser();
    
        // Use the resolved User instead of redefining it
        const GatePass = this.config?.gatePass;
    
        // Ensure gatePass is defined
        if (!GatePass) {
            console.error('gatePass configuration is missing.');
            return null;
        }
    
        
        console.log(GatePass);
    
        const trace = true;
    
        if (pageId) {
            this.pageId = pageId;
        }
    
        if (trace) console.log("Loading...;", pageId);
    
        try {
            if (trace) console.log("Waiting for the promise to resolve and get the user data;", pageId);
    
            const role = User?.role || 'guest';
    
            console.log({ User });
            if (trace) console.log("Resolved user data:", { User });
    
            if (!Array.isArray(GatePass)) {
                throw new Error("Invalid gatePass configuration");
            }
    
            let passNow = true;
            let redirect = "";
    
            for (const gate of GatePass) {
                // Check if the pageId starts with gate.path
                if (trace) console.log("Checking: " + gate.path + " & " + pageId);
    
                if (pageId.startsWith(gate.path)) {
                    passNow = false;
                    redirect = gate.redirect;
                    if (trace) console.log("Match found for path:", gate.path);
    
                    // Check if the user's role matches the gate's role
                    let isAGO = 0;


                    if(role!=='guest'){

                    isAGO = await this.isGroup(gate.role, User);
    }
                    if (trace) console.log(isAGO, "<- is a go!! Checking if roles match:", gate.role + " & " + role);
    
                    if (isAGO) {
                        return pageId;
                    } else {
                        return redirect;
                    }
                }
            }
    
            // If no match is found, return the pageId (or handle as 404)
            return passNow ? pageId : redirect;
    
        } catch (error) {
            console.error('Error fetching user data:', error);
            return GatePass?.redirect || 'error'; // Return a redirect path or an error identifier
        }
    }
    

 async pagePass(pageId) {
        
    
    
        try {
              // Wait for the promise to resolve and get the user data
           //  const user = await this.getUser();
           // const user = await this.user;
          const user =  await this.getUser();
    
           console.log(pageId);
    
              for (const gate of gatePass) {
                // Check if the pageId starts with gate.path
                if (pageId.startsWith(gate.path)) {
                  // Check if the user's role matches the required role
                  if (user.role === gate.role) {

                    this.ifPass =true;


                   // return pageId; // Access granted
                  } else {

                    this.ifPass =true;
                    //return
                    this.redirect = gate.redirect; // Access denied, return redirect
                  }
                }
              }
              this.ifPass =true;
              this.redirect =null;
             // return pageId; // Return '404' if no match for pageId path
            } catch (error) {
              console.error('Error fetching user data:', error);
              return 'error'; // Handle error case
            }
          }


 async  getpage(){


return  this.currentPage;

 }

  
    loadTemplate() {
        if (this.config.template === true) {
            this.loadTemplateFile('./pages/template.html');
        } else if (typeof this.config.template === 'string') {
            this.loadTemplateFile(this.config.template);
        } else if (this.config.template === 'dynamic') {
            // Implement dynamic template loading logic here
        }
    }

    loadTemplateFile(templatePath) {
        fetch(templatePath)
            .then(response => response.text())
            .then(html => {
                document.body.innerHTML = html;
                this.loadInitialPage();

            })
            .catch(error => console.error('Error loading template:', error));
    }

setActive(event){
 if(event)event.preventDefault(); 
    const links = document.querySelectorAll('a');

    links.forEach(link => {

    link.classList.remove('active');
   
    })


   
           // Prevent the default action if needed
          event.target.classList.add('active');
          //this.loadPage( event.target.href);
          window.location.href =  event.target.href;
          
   
}

markActive(event){
    if(event)event.preventDefault(); 
       const links = document.querySelectorAll('a');
   
       links.forEach(link => {
   
       link.classList.remove('active');
      
       })
   
   
      
              // Prevent the default action if needed
             event.target.classList.add('active');
             //this.loadPage( event.target.href);
          //   window.location.href =  event.target.href;
             
      
   }

    setupEventListeners() {
        window.addEventListener('hashchange', (event) => this.handleUrlChange(null,event));
        window.addEventListener('popstate', (event) => this.handleUrlChange(null,event));
    }

queryCheck(input){

 // Define the separator
 const separator =this.$QS;

 console.log("===============>"+separator+"<================");


 // Check if the separator is present in the input string
 if (!input.includes(separator)) {
  //console.error("Separator not found in the input string.");
  return input; // or handle this case differently
}

    
 // Split the string into two parts
 const [pageid, params] = input.split(separator);
 
 // Initialize an array to hold the result objects
//const result = [];

 // Split the params into key-value pairs
 const pairs = params.split('&');

 // Iterate over each pair and create the corresponding object
 pairs.forEach(pair => {
     const [key, value] = pair.split('=');
    this.BUFFER.push({
         pageid: pageid,
         key: key,
         value: value
     });
 });

 return  pageid;
}



async inPage(pageId){

//const separatedStrings = inputString.split(" @");
console.log("Verhig input", pageId);



const rPageId= await this.handleUrlChange(this.queryCheck(pageId))   ;
console.log("retuned input", rPageId);
//let newUrl = "https://singflex.com/"+pageId;
       return rPageId;
   
   
   
   }






    async handleUrlChange(pageId,event) {



   this.view('main', false);
      
     //  alert('me!')
       pageId = (pageId)?pageId: this.getPageIdFromUrl();

        console.log("===",pageId,"==============");
       if(pageId.trim()=="#"){return false };

       //return  this.checkProtectedRoute(pageId).then((pageId)=>{
       const nextPageId = await this.validatePageAccess(pageId);
     

       if(nextPageId ){this.loadPage(nextPageId) ;
        
        window.history.replaceState({}, '', "./?"+nextPageId);

        console.log("set page to ",nextPageId);


setTimeout(() => {

  this.PageAction(nextPageId);
    
}, this.pat);



       }


       return  pageId;

    }

    xgetPageIdFromUrl(url) {



        const hash = window.location.hash.slice(1);
        const urlParams = new URLSearchParams(window.location.search);
        const searchLine = String( window.location.search);

        const pageParam = urlParams.get('page') || urlParams.get('main');
        const mark =(searchLine.startsWith("?")("?") )? urlParams.replace("?",""):null; 
        const pathSegments = window.location.pathname.split('/');

        return hash || pageParam || pathSegments[pathSegments.length - 1]  || mark|| 'home';
      
    }


 getPageIdFromUrl(url) {
      const hash = window.location.hash.slice(1);
      const urlParams = new URLSearchParams(window.location.search);
      const searchLine = window.location.search;
  
      const pageParam = urlParams.get('page') || urlParams.get('main');
      
      // Check if searchLine starts with "?", and if so, remove it
      const mark = searchLine.startsWith("?") ? searchLine.slice(1) : null; 
  
      const pathSegments = window.location.pathname.split('/');
      const lastPathSegment = pathSegments[pathSegments.length - 1];
  
      return hash || pageParam || lastPathSegment || mark || 'home';
  }

    xxgetPageIdFromHurl(url) {
      
      //window.history.pushState({}, '', url);
      const WinLo =(url)? new URL(url) :window.location;
      const searchLine =  String(WinLo.search);

      const hash =  WinLo.hash.slice(1);
      const urlParams = new URLSearchParams( WinLo.search);
      const mark =(searchLine.startsWith("?") )? urlParams.replace("?",""):null; 
      const pageParam = urlParams.get('page') || urlParams.get('main');
      const pathSegments =  WinLo.pathname.split('/');

      return hash || pageParam || pathSegments[pathSegments.length - 1] || mark|| 'home';
  }


 getPageIdFromHurl(url) {
    // If a URL is provided, use it; otherwise, use the current window's location.
    const WinLo = url ? new URL(url) : window.location;
    const searchLine = String(WinLo.search);

    // Extract the hash value (the part after #) without the #
    const hash = WinLo.hash.slice(1);

    // Create a URLSearchParams object to easily get query parameters
    const urlParams = new URLSearchParams(WinLo.search);

    // If the search line starts with "?", remove the "?" and return the remaining part
    const mark = searchLine.startsWith("?") ? searchLine.slice(1) : null;

    // Get the 'page' or 'main' query parameter if available
    const pageParam = urlParams.get('page') || urlParams.get('main');

    // Split the pathname into segments and get the last segment
    const pathSegments = WinLo.pathname.split('/');
    const lastPathSegment = pathSegments[pathSegments.length - 1];

    // Return the appropriate page identifier
    return hash || pageParam || lastPathSegment || mark || 'home';
}


    xgetPageIdFromHref(url) {
     
      urlObject = new URL(url)
      const hash = urlObject.hash.slice(1);
      const urlParams = new URLSearchParams(  urlObject.searchParams);
      const pageParam = urlParams.get('page') || urlParams.get('main');
      const pathSegments = window.location.pathname.split('/');

      return hash || pageParam || pathSegments[pathSegments.length - 1] || 'home';
  }

 async loadInitialPage(pageId, callback) {

pageId=pageId||this.getPageIdFromUrl();


this.lastPage = pageId;
this.Page2go=pageId;

//console.log( this.Page2go,"//const feedback = this.checkProtectedRoute(pageId).then((result)=>{");

pageId = await this.validatePageAccess(pageId);


if(pageId)this.loadPage(pageId);


setTimeout(() => {
   this.PageAction(pageId); 
}, this.pat);



//if(!result)return false;

// });


if(callback)callback(pageId);
return  pageId;
      

    }


loadPage(pageId) {
        const page = this.getPageInfo(pageId);

        if (!page) {


            this.loadNotFoundPage();
            return;


        }

        this.currentPage = page;
        this.updatePageMetadata();

        if (this.pageLoad.some(p => p.page_id === pageId)) {
            this.renderPage(pageId);
        } else {
            this.fetchAndRenderPage(pageId);
        }

        this.preloadOtherPages();
    }


  
 async onClick(e){

this.clickExemptedIDs =[];
//e.preventDefault();




const hasClickPassClass = e.target.classList.contains('clickPass');
const isExemptedID = this.clickExemptedIDs.includes(e.target.id);


    if (!hasClickPassClass && !isExemptedID) {
      // Prevent the default action for elements not matching the criteria
      e.preventDefault();
      
      // Custom handling for non-exempted elements
      console.log('Click event prevented from reloading or refreshing the page:', e.target?.id);
  } else {
      // Allow default action for exempted elements
      console.log('Default action allowed for:', e.target?.id);
  }



///Mark Active link



const href = await e.target.href;

//console.log ("e.target.href=",href);

if(href&&href!==""){

const pageId = this.getPageIdFromHurl(href);

    Promise.all([pageId])
    .then((results) => {
       // console.log(results); // Output: ['Result 1', 'Result 2', 'Result 3']
    
    this.inPage(results[0]);
    
    })
    .catch((error) => {

        console.error('One of the promises failed:', error);
    });



    const links = document.querySelectorAll('a');

    links.forEach(link => {
    
    link.classList.remove('active');
    
    })



   // alert(e.target.href);
} else{





}



   }

 goPage(pageId){
//    alert('here!');

        this.view('main', false);
   
        if(pageId.trim().includes("#")){
  ///?page=     
       pageId=pageId.replace(/#/g, '');;
        }

        if(pageId.trim().includes("?page=")){
            ///?page=     
                 pageId=pageId.replace('?page=', '');

                 return false
        }

        if(pageId.trim().includes("?page=false")){
            ///?page=     
                 pageId=pageId.replace('?page=fasle', '');

                 return false
        }

        if(pageId.trim().includes("false")){
            ///?page=     
                 pageId=pageId.replace('false', '');

                 return false
        }

 

      




   // window.location.href ="/.?page="+pageId;
   //this.inPage(pageId);
   console.log("ignoting Calling page ","/.?page="+pageId);
  
       
   }
       
       

    hrefId(pageId){

        if(!pageId.trim().includes("#")){
       
       pageId="#"+pageId;
        }
   
       
       this.goPage(pageId);
       
       
           }
       
       


    async getPage(pageId) {

  

        if(pageId=="#"){


        
            return false
            
                   }

        const pagePath = `${this.default_file_location}${pageId}.html`;
console.log('now checking', pagePath);
        
        try {

            const response = await fetch(pagePath);
            
            if (!response.ok) {
                this.loadNotFoundPage();
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            
            const html = await response.text();
            
            // Create a temporary element to parse the HTML
            const tempElement = document.createElement('div');
            tempElement.innerHTML = html;
            
            // Extract title from the <title> tag
            const titleElement = tempElement.querySelector('title');
            const title = titleElement ? titleElement.textContent : `${pageId} Page`;
            
            // Extract heading from the first <h1> tag
            const headingElement = tempElement.querySelector('h1');
            const heading = headingElement ? headingElement.textContent : `${pageId} Heading`;
            
            // Create and return the page info object
            const pageInfo = {
                page_id: pageId,
                page: `${pageId}.html`,
                title: title,
                heading: heading
            };
            
            // Update the pages array with this information
            const existingPageIndex = this.pages.findIndex(p => p.page_id === pageId);
            if (existingPageIndex !== -1) {
                this.pages[existingPageIndex] = pageInfo;
            } else {
                this.pages.push(pageInfo);
             
             setTimeout(() => {
                this.FirstAction(pageId);  
             }, this.fat);
             
              


            }
            
            return pageInfo;
        } catch (error) {

            console.error(`PageEngine 3.0 Error checking/loading page ${pageId}:`, error);
            return null;
        }


    }

getPageInfo(pageId) {

let iSeeAm = this.pages.find(p => p.page_id === pageId);


let eDay = null;

if (!iSeeAm){

eDay = this.getPage(pageId);


}

        return (eDay)? eDay : iSeeAm;
    }

    updatePageMetadata() {
        document.title = this.currentPage.title;
        const headingElement = document.querySelector('h1');
        if (headingElement) {
            headingElement.textContent = this.currentPage.heading;
        }
    }

    renderPage(pageId) {
        const pageContent = this.pageLoad.find(p => p.page_id === pageId).content;
        document.getElementById('main').innerHTML = pageContent;
    }

    fetchAndRenderPage(pageId) {

        window.scroll({
            top: 0,
            left: 0,
            behavior: 'smooth'
          });

        if(pageId=="#")pageId = this.hashPage; 
        const pagePath = `./pages/${pageId}.html`;

     //   console.log('loading..', pagePath);
        fetch(pagePath)
            .then(response => response.text())
            .then(html => {
          
                this.pageLoad.push({ page_id: pageId, content: html });
                this.renderPage(pageId);
            })
            .catch(error => { 
                this.loadNotFoundPage();
                //console.error('Error loading page:', error);
               
            });
    }

    loadNotFoundPage() {
      

        fetch('./pages/system/404.html')
        .then(response =>  response.text() )
            .then(html => {
                document.getElementById('main').innerHTML = html;
            })
            .catch(error => {
               // console.error('Error loading 404 page:', error);
                document.getElementById('main').innerHTML = 'Page not found or coming soon.';
            });
    }

    preloadOtherPages() {
        this.pages.forEach(page => {
            if (page.page_id !== this.currentPage.page_id && !this.pageLoad.some(p => p.page_id === page.page_id)) {
                this.fetchAndCachePage(page.page_id);
            }
        });
    }

    fetchAndCachePage(pageId) {
        const pagePath = `./pages/${pageId}.html`;
        fetch(pagePath)
            .then(response => response.text())
            .then(html => {
                this.pageLoad.push({ page_id: pageId, content: html });
            })
            .catch(error => console.error('Error preloading page:', error));
    }

    setPages(pages) {
        this.pages = pages;
    }

    load(pageId) {
        window.location.hash = pageId;
    }

//On login is called  when ever a login or resession in done and user is loged in 

//session part

async setSession(value,key,hours ) {
  console.log ("cs001 -A");
this.oldUser = await this.getUser();

     


//this.setRole(User.role);
 
 hours= (this.HoursCookie)? hours: this.HoursCookie||6;

 key=(key)? key: this.config.userSessionKey||"EngineUserKey" ;

//key=(key)? key: this.config.userSessionKey ;

value = (value)? value :  this.oldUser;
this.User = value;
this.user = value;
this.Role =value.role;
//alert(this.User.email);
if(value !==this.oldUser)this.isLogin=null; ;



//hours =(hours)? hours :time;

// Set cookie

console.log ("cs001 -B saving session old - New ",this.oldUser, value);

return new Promise((resolve, reject) => {
  try {
    const expires = new Date();
    expires.setTime(expires.getTime() + hours * 60 * 60 * 1000);
    document.cookie = `${key}=${JSON.stringify(value)};expires=${expires.toUTCString()};path=/`;
    resolve();
  } catch (error) {
    reject(error);
  }
});


}

 killSession(key) {
  console.log ("cs003 -A");
    // Check if a session exists


   

    key =(key)?key : this.config.userSessionKey;




    return new Promise((resolve, reject) => {
      try {
        document.cookie = `${key}=;expires=Thu, 01 Jan 1970 00:00:00 UTC;path=/;`;
        resolve();
this.setRole();


      } catch (error) {
        reject(error);
      }
    });
}

async setRole(Role){


  if(Role){

    switch(Role){
case    'guest':  
    this.isMember=null;
    this.isArtist = null;
    this.isAdmin = null;
    this.isSuperAdmin= null;

  break;

case 'member':

    this.isMember=true;
    this.isArtist = null;
    this.isAdmin = null;
    this.isSuperAdmin= null;


break;

case 'artist':

    this.isMember = true;
    this.isArtist = true;
    this.isAdmin  = null;
    this.isSuperAdmin= null;
case 'admin':

    this.isMember=true;
    this.isArtist = true;
    this.isAdmin = true;
    this.isSuperAdmin= null;

    case 'superadmin':
    this.isMember=true;
    this.isArtist = true;
    this.isAdmin = true;
    this.isSuperAdmin= true;


    


default:
  


    }



  } else {

    this.user = null;  //session user 
    this.isMember=null;
    this.isArtist = null;
    this.isAdmin = null;
    this.isSuperAdmin= null;


  }






}

async isRole(Role){


const User = await this.getUser();
  Role = Role.toLowerCase();
console.log ("checking .. Role "+Role);
//alert(" The Role is="+Role);

switch(Role){


      
case    'guest':  

if(!User) return true;
  break;

case 'member':

if(this.isMember) return true;

if( this.isArtist ) return  true;

if(  this.isAdmin ) return  true;

if(  this.isSuperAdmin) return  true;

break;

case 'artist':

  if( this.isArtist ) return  true;


  if(  this.isAdmin ) return  true;

  if(  this.isSuperAdmin) return  true;

case 'admin':




if(  this.isAdmin ) return  true;

if(  this.isSuperAdmin) return  true;


    case 'superadmin':

    if(  this.isSuperAdmin) return  true;



default:
  return false;


    }



 



}


async isGroup(Role, User) {
  // Resolve the User object
  User = User || this.User;

  const Rolex = User.role;
  // Convert the role to lowercase for consistent comparison
  const xRole = Role.toLowerCase().trim();

  console.log("Checking Role: " + Rolex);

  // Define role-checking logic
  switch (Rolex) {
    case 'guest':
      console.log("rolex is now at", Rolex);
      // If the user is not logged in, consider them a guest
      return !User;

    case 'superadmin':
      console.log("rolex is now at", Rolex);
      // Check if the user is a member, artist, admin, or super admin
      return ['member', 'artist', 'admin', 'superadmin'].includes(xRole);

    case 'admin':
      console.log("rolex is now at", Rolex);
      // Check if the user is a member, artist, or admin
      return ['member', 'artist', 'admin'].includes(xRole);

    case 'artist':
      console.log("rolex is now at", Rolex);
      // Check if the user is a member or artist
      return ['member', 'artist'].includes(xRole);

    case 'member':
      console.log("rolex is now at", Rolex);
      // Check if the user is a member
      return xRole === 'member';

    default:
      console.log("rolex is now at None!");
      // If no match, return false
      return false;
  }
}


async laxisRole(Role) {
  // Resolve the User object
  const User = await this.User;

  // Convert the role to lowercase for consistent comparison
  Role = Role.toLowerCase().trim();

  console.log("Checking Role: " + Role);

  // Define role-checking logic
  switch (Role) {
    case 'guest':
      // If the user is not logged in, consider them a guest
      return !User;

    case 'member':
      // Check if the user is a member, artist, admin, or super admin
      return this.isMember || this.isArtist || this.isAdmin || this.isSuperAdmin;

    case 'artist':
      // Check if the user is an artist, admin, or super admin
      return this.isArtist || this.isAdmin || this.isSuperAdmin;

    case 'admin':
      // Check if the user is an admin or super admin
      return this.isAdmin || this.isSuperAdmin;

    case 'superadmin':
      // Check if the user is a super admin
      return this.isSuperAdmin;

    default:
      // If no match, return false
      return false;
  }
}


async getSession(key) {
    key =(key)?key : this.config.userSessionKey;
    
    console.log ("cs002 -A ="+key);
    

    return new Promise((resolve, reject) => {
      try {
        const cookieArr = document.cookie.split(';');
        for (let i = 0; i < cookieArr.length; i++) {
          const cookiePair = cookieArr[i].split('=');


          if (key === cookiePair[0].trim()) {

         const User =   JSON.parse(decodeURIComponent(cookiePair[1]));
         console.log ("Got User and Setting it -- cs002 -B-->",{User});

      

//this.setRole();

            
            resolve(User);

            
     
          }
        }


        console.log ("cs002 -B", );
        resolve(null);
      } catch (error) {
        reject(error);
      }
    });

}



checkPass(mode, user){

user =(user)? user: this.user;

if(!user)return false;

switch(mode){

case 'user'||'login'||'member':

if (user) return true;

break;

case user.role:return true;

break;

default : 

if (Array.isArray(mode)) {
    // If it is an array, check if it includes the user's role
    return mode.includes(user.role);
  } 
return false



    }





}

async setUser(user){

if(!user)this.getSession(this.key);

//alert(user.username);
if(user){
this.activeUser=user;
this.user=user;
this.navUpdate(user);
}

}

async xxxxxxcheckProtectedRoute(pageId, callback) {

    if(pageId===false) return null;
this.trace =true;

    


    // Ensure protected is an array
   const  protectedRoute = this.protectedRoute;

   console.log ( pageId, protectedRoute, "user ="+this.user);

    if (!Array.isArray(protectedRoute)) {
      console.error('Protected routes must be an array');
      return null;
    }
  
    // Loop through each protected route object
    for (let routeObj of protectedRoute) {
      // Check if the route property exists and is a string
      if (typeof routeObj.route !== 'string') {
        console.error('Route must be a string');
        continue;
      }
    

    console.log ( pageId, protectedRoute, "user =", this.user, "Allowed for ="+routeObj.allow);

  console.log("|"+routeObj.route+"|","|"+pageId+"|");
      // Check if the pageId starts with the route
      if (pageId.startsWith(routeObj.route)) {


        console.log ( pageId, "user ="+this.user, "Allowed for ="+routeObj.allow);

let nowUser = this.user;

//alert(nowUser);
if(!nowUser){


  //  const protectedRoute = [{route:'admin/', allow:['admin'],redirect:'adminonly'}, {route:'artist/', allow:['artist'],redirect:'artistonly'} , {route:'cloud/', allow:['login'],redirect:'needlogin'}];

    
  console.log("user not loged in while asking for a protected route"+routeObj.allow);

   return  routeObj.redirect;

}
//console.log(nowUser);

//alert(routeObj.allow);


      if (!this.checkPass(routeObj.allow)) {

        //alert("you are OK! "+nowUser.firstname );
        if(this.trace) console.log('returning false ...');
        return false;
     }
      else {
        

       // alert(routeObj.allow);
        window.location.href = routeObj.redirect;
    
     return routeObj.redirect;
    }
       


      }
      
    }
  
    // If no match is found, return null
   if(this.trace) console.log('returning ...', pageId);
    return pageId;
  }

view(divId, show) {
    var element = document.getElementById(divId);
    
    if (element) {
      if (show) {
        element.style.display = "block"; // Shows the div
      } else {
        element.style.display = "none";  // Hides the div
      }
    } else {
      console.log(`Element with ID ${divId} not found.`);
    }
  }




}



class CookieConsent {
    constructor() {
        this.cookieBanner = document.getElementById('cookie-banner');
        this.acceptButton = document.getElementById('accept-cookies');
        this.rejectButton = document.getElementById('reject-cookies');
        this.settingsLink = document.getElementById('cookie-settings');

        this.sessionEngine = {
            setSession: (key, value, days) => this.setCookieSession(key, value, days),
            getSession: (key) => this.getCookieSession(key),
            killSession: (key) => this.deleteCookieSession(key),
        };

        this.cookieName = 'singflex_cookie_consent';
        this.cookieExpiry = 365; // days

        this.init();
    }

    init() {
        if (!this.sessionEngine.getSession(this.cookieName)) {
            this.showBanner();
        }

        this.acceptButton.addEventListener('click', () => this.acceptCookies());
        this.rejectButton.addEventListener('click', () => this.rejectCookies());
        this.settingsLink.addEventListener('click', (e) => this.showSettings(e));
    }

    showBanner() {
        this.cookieBanner.classList.add('show');
    }

    hideBanner() {
        this.cookieBanner.classList.remove('show');
    }

    acceptCookies() {
        this.sessionEngine.setSession(this.cookieName, 'accepted', this.cookieExpiry);
        this.hideBanner();
        console.log('Cookies accepted');
    }

    rejectCookies() {
        this.sessionEngine.setSession(this.cookieName, 'rejected', this.cookieExpiry);
        this.hideBanner();
        console.log('Cookies rejected');
    }

    showSettings(e) {
        e.preventDefault();
        console.log('Show cookie settings');
    }

    // Set session using cookies
    setCookieSession(name, value, days) {
        let expires = '';
        if (days) {
            const date = new Date();
            date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
            expires = '; expires=' + date.toUTCString();
        }
        document.cookie = `${name}=${value || ''}${expires}; path=/; SameSite=Lax; Secure`;
    }

    // Get session value from cookies
    getCookieSession(name) {
        const nameEQ = `${name}=`;
        const ca = document.cookie.split(';');
        for (let i = 0; i < ca.length; i++) {
            let c = ca[i];
            while (c.charAt(0) === ' ') c = c.substring(1, c.length);
            if (c.indexOf(nameEQ) === 0) return c.substring(nameEQ.length, c.length);
        }
        return null;
    }

    // Delete cookie session (kill session)
    deleteCookieSession(name) {
        document.cookie = `${name}=; Max-Age=-99999999; path=/; SameSite=Lax; Secure`;
    }
}


 
  
// Initialize the cookie consent
document.addEventListener('DOMContentLoaded', () => {
    new CookieConsent();
});