<?php
// src/.env/db_config.php

// Load environment variables if using a .env file
if (file_exists(__DIR__ . '/../../.env')) {
    $env = parse_ini_file(__DIR__ . '/../../.env');
    foreach ($env as $key => $value) {
        putenv("$key=$value");
    }
}

// Database configuration
//define('DB_HOST', 'localhost');
//define('DB_USER', 'skillenter');
//define('DB_PASS', 'Skent@2024');
//define('DB_NAME', 'skillenter');

// Database configuration constants
define('DB_HOST', getenv('DB_HOST') ?: 'localhost');
define('DB_USER', getenv('DB_USER') ?: 'skillenter');
define('DB_PASS', getenv('DB_PASS') ?: 'Skent@2024');
define('DB_NAME', getenv('DB_NAME') ?: 'skillenter');

/**
 * Get database connection
 * @return mysqli Database connection
 * @throws Exception if connection fails
 */
function getDBConnection() {
    static $connection = null;
    
    if ($connection === null) {
        try {
            $connection = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
            
            if ($connection->connect_error) {
                throw new Exception('Database connection failed: ' . $connection->connect_error);
            }
            
            // Set charset to handle special characters correctly
            $connection->set_charset("utf8mb4");
            
            // Set error reporting
            mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
            
        } catch (Exception $e) {
            error_log('Database Connection Error: ' . $e->getMessage());
            throw new Exception('Database connection error occurred. Please try again later.');
        }
    }
    
    return $connection;
}

/**
 * Close database connection
 * @param mysqli $connection Database connection to close
 * @return void
 */
function closeDBConnection($connection) {
    if ($connection instanceof mysqli && !$connection->connect_error) {
        $connection->close();
    }
}

// Function to sanitize input data
function sanitizeInput($data) {
    $connection = getDBConnection();
    if (is_array($data)) {
        return array_map(function($item) use ($connection) {
            return $connection->real_escape_string($item);
        }, $data);
    }
    return $connection->real_escape_string($data);
}
?>