// Form validation and submission script
 function submitJoinus() {
    const form = document.querySelector('form');
    
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        if (validateForm()) {
            submitForm();
        }
    });

    function validateForm() {
        let isValid = true;
        const name = document.getElementById('name').value.trim();
        const email = document.getElementById('email').value.trim();
        const phone = document.getElementById('phone').value.trim();
        const qualification = document.getElementById('qualification').value.trim();
        const field = document.getElementById('field').value.trim();
        const experience = document.getElementById('experience').value;
        const availability = document.getElementById('availability').value;
        const startDate = document.getElementById('start_date').value;
        const training = document.getElementById('training').value;

        // Basic validation
        if (name === '' || email === '' || phone === '' || qualification === '' || field === '' || 
            experience === '' || availability === '' || startDate === '' || training === '') {
            alert('All fields are required');
            isValid = false;
        }

        // Email validation
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (!emailRegex.test(email)) {
            alert('Please enter a valid email address');
            isValid = false;
        }

        // Phone validation (basic)
        const phoneRegex = /^\d{10}$/;
        if (!phoneRegex.test(phone)) {
            alert('Please enter a valid 10-digit phone number');
            isValid = false;
        }

        // Experience validation
        if (isNaN(experience) || parseInt(experience) < 0) {
            alert('Please enter a valid number for years of experience');
            isValid = false;
        }

        return isValid;
    }

    function submitForm() {
        const formData = new FormData(form);
        const jsonData = {};
        formData.forEach((value, key) => {
            jsonData[key] = value;
        });

        fetch('submit_join_form.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(jsonData),
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Application submitted successfully!');
                form.reset();
            } else {
                alert('Error submitting application. Please try again.');
            }
        })
        .catch((error) => {
            console.error('Error:', error);
            alert('An error occurred. Please try again later.');
        });
    }
};